<?php
/**
 * ServiceProvider.php 2020-06-10
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

namespace Gambio\Shop\Price\Product\Database;

use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\Price\Product\Database\Listener\OnCreateSellingUnitListener;
use Gambio\Shop\Price\Product\Database\ValueObjects\CustomersStatusShowPrice;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnCreateSellingUnitEvent;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * @property  Container container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    
    /**
     * @var array
     */
    protected $provides = [
        OnCreateSellingUnitListener::class,
        CustomersStatusShowPrice::class
    ];
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnCreateSellingUnitEvent::class,
                                          OnCreateSellingUnitListener::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(OnCreateSellingUnitListener::class);
    
        $showPriceStatus = isset($_SESSION['customers_status']['customers_status_show_price'])
                           && (int)$_SESSION['customers_status']['customers_status_show_price'] === 1;
        
        $this->container->share(CustomersStatusShowPrice::class)->addArgument($showPriceStatus);
    }
}